import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/core/errors/failure.dart';
import 'package:razinsoft_rider/data/models/chat_message_response/chat_message_response.dart';
import 'package:razinsoft_rider/data/models/common_response.dart';
import 'package:razinsoft_rider/data/repositories/base_repository.dart';

import '../../domain/interfaces/chat_service_interface.dart';
import 'interfaces/chat_repo_interface.dart';

class ChatRepoImpl extends BaseRepository implements IChatRepo {
  final IChatService chatService;

  ChatRepoImpl({required this.chatService});
  @override
  Future<Either<Failure, ChatResponse>> getMessage(
      {required int userId}) async => await safeApiCall(() async {
      final response = await chatService.getMessage(userId);
      return ChatResponse.fromJson(response.data);
    });

  @override
  Future<Either<Failure, CommonResponse>> sendMessage(
      {required int receiverId, required String message}) async => await safeApiCall(() async {
      final response = await chatService.sendMessage(message: message, receiverId: receiverId);
      return CommonResponse.fromMap(response.data);
    });
}
